set -x 
dir=`pwd`
whoami=`whoami`

[  "$whoami" = "root" ] || echo must be root 
[  "$whoami" = "root" ] ||  exit 1

mixfile=$PWD/joymixer.tgz
cd /
dir=`pwd`
[ "$dir" = "/" ] || echo must be in / 
[ "$dir" = "/" ] || exit 2

tar -xzvf $mixfile

systemctl enable sticksetup.service
systemctl start sticksetup.service
systemctl status sticksetup.service

cat <<EOF
  Hello :-)
  
  joymixerUI is the GUI for making a map file for joymap. 
  joymap is copyright Alexandre Hardy. 
  this is the homepage :  https://sourceforge.net/p/linuxjoymap/wiki/Home/ 
  where you can get the original source of linux joymap mixer
  
  What does it do, joymap... ?
  
  It allows you to combine different sticks / wheels / pads into a single virtual joystick.  
  
  old games like Redbaron3D running in wine will then see one stick, with e.g. your flightstick and your rudder pedals combined.
  maybe even with your gas throttle, brakes. whatever you have.

  this setup / script only works with systemd :  that is almost every linux distro. if you 
  chose to have such a non systemd distro, you probably know what to do now. ( use the scripts, set it up for your distro. it will work. )
  
  After running this installjoymix.sh your sticksetup.service should now be running,
  and automatically restart whenever you reboot your system.

  enjoy joymixer / joymap 

start with running joymixerUI and create a map file, save it with somename.map
  
then test it by doing the following 
   (the unplugging and plug in again is necessary for old games like Redbaron3D : they only see joystick 0 ;
   newer games might not need this )
  
  # UNPLUG your sticks 
  # run your map you just created. (see next command)
  # this ENSURES that the virtual, combined joystick will get js0 , the primary joystick device in linux.
  # old games, and also REDBARON3D  ONLY see joystick 0  ( /dev/input/js0 )
  
  loadmap somename.map
  
  # if it loads without complaints :   PLUG IN YOUR JOYSTICKS: these will now get higher numbers : js2, js3 or whatever is free
  #
  # then, stop loadmap somename.map  
 
  # then start loadmap AGAIN, which will now find your real joysticks with the higher number,
  # and combine them in js0, the first joystick in your systemctl
  
  
  #In a different console window you can now test :
  
  jstest /dev/input/js0
  
  # move your sticks / pedals, you should see the numbers change /the buttons go on/off
  
  # enjoy your combined sticks, hotkey strokes etc. :-)
  
  
EOF

