unit joymixunit;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, Forms, Controls, Graphics, Dialogs, StdCtrls, ActnList,
  ExtCtrls, Buttons, Grids, Menus, process, fileutil, lazfileutils, RTTICtrls,
  keyboard, math, baseunix, unix, stickmap,licunit;

type

  TjsParts = ( aX, aY, aZ, aRx, aRy, aRz, aThrottle, aRudder, aWheel, aGas, aBrake, unk1, unk2, unk3, unk4, unk5, Hat0X, Hat0Y,
                b288,b289,b290,b291,b292,b293,b294,b295,b296,b297,b298,b299);
  TjsArray = array [aX..b299] of tcombobox;

  { Tjsctl }

  Tjsctl = class(TForm)
    axlab10: TLabel;
    axlab11: TLabel;
    axlab12: TLabel;
    axlab13: TLabel;
    axlab14: TLabel;
    axlab15: TLabel;
   ax_dis0: TComboBox;
    ax_dis1: TComboBox;
     ax_dis4: TComboBox;
    ax_dis5: TComboBox;
    ax_dis2: TComboBox;
    ax_dis3: TComboBox;
    ax_dis6: TComboBox;
    ax_dis7: TComboBox;
    ax_dis8: TComboBox;
    ax_dis9: TComboBox;
    ax_dis10: TComboBox;
    ax_dis11: TComboBox;
    ax_dis12: TComboBox;
    ax_dis13: TComboBox;
    ax_dis14: TComboBox;
    ax_dis15: TComboBox;
    ax_dis16: TComboBox;
    ax_dis17: TComboBox;
    dz0: TEdit;
    dz1: TEdit;
    dz10: TEdit;
    dz11: TEdit;
    dz12: TEdit;
    dz13: TEdit;
    dz14: TEdit;
    dz15: TEdit;
    dz16: TEdit;
    dz17: TEdit;
    dz2: TEdit;
    dz3: TEdit;
    dz4: TEdit;
    dz5: TEdit;
    dz6: TEdit;
    dz7: TEdit;
    dz8: TEdit;
    dz9: TEdit;
    Label19: TLabel;
    Label20: TLabel;
    PopupMenu1: TPopupMenu;
    showlic: TButton;
    normbtns: TCheckGroup;
    rungame: TComboBox;
    gamelist: TMemo;
    resetjoymix: TButton;
    shftbtns: TCheckGroup;
    shftyn: TCheckBox;
    Invertax: TCheckGroup;
//    debugmemo: TMemo;
    exitmap: TButton;
    shiftLabel19: TLabel;
    loadmap: TButton;
    Label17: TLabel;
    Label18: TLabel;
    loadmapcmd: TMemo;
    axlab9: TLabel;
    rudderlab1: TLabel;
    src0: TComboBox;
    src1: TComboBox;
    src10: TComboBox;
    src11: TComboBox;
    src12: TComboBox;
    src13: TComboBox;
    src14: TComboBox;
    src15: TComboBox;
    src16: TComboBox;
    src17: TComboBox;
    shiftbtn: TComboBox;
    src2: TComboBox;
    src3: TComboBox;
    src4: TComboBox;
    src5: TComboBox;
    src6: TComboBox;
    src7: TComboBox;
    src8: TComboBox;
    src9: TComboBox;
    throttlelab: TLabel;
    rxlabel: TLabel;
    rylabel: TLabel;
    B1: TLabel;
    B10: TLabel;
    B11: TLabel;
    B12: TLabel;
    B13: TLabel;
    B14: TLabel;
    B15: TLabel;
    B16: TLabel;
    B17: TLabel;
    B2: TLabel;
    B3: TLabel;
    B4: TLabel;
    B5: TLabel;
    B6: TLabel;
    B7: TLabel;
    B8: TLabel;
    B9: TLabel;
    bu00: TComboBox;
    bu01: TComboBox;
    bu02: TComboBox;
    bu10: TComboBox;
    bu11: TComboBox;
    bu03: TComboBox;
    bu04: TComboBox;
    bu05: TComboBox;
    bu06: TComboBox;
    bu07: TComboBox;
    bu08: TComboBox;
    bu09: TComboBox;
    bu12: TComboBox;
    bu13: TComboBox;
    bu14: TComboBox;
    bu15: TComboBox;
    bu16: TComboBox;
    bu17: TComboBox;
    kbdcode12: TEdit;
    kbdcode13: TEdit;
    kbdcode14: TEdit;
    kbdcode15: TEdit;
    kbdcode16: TEdit;
    kbdcode17: TEdit;
    kbdinp12: TEdit;
    kbdinp13: TEdit;
    kbdinp14: TEdit;
    kbdinp15: TEdit;
    kbdinp16: TEdit;
    kbdinp17: TEdit;
    keybut12: TCheckBox;
    keybut13: TCheckBox;
    keybut14: TCheckBox;
    keybut15: TCheckBox;
    keybut16: TCheckBox;
    keybut17: TCheckBox;
    rudderlab: TLabel;
    translate_btns: TButton;
    runitscript: TMemo;
    showUIhelp: TButton;
    loadsticks: TButton;
    joylsscript: TMemo;
    getmapscript: TMemo;
    Label16: TLabel;
    savemapbut: TButton;
    loadmapbut: TButton;
    kbdinp10: TEdit;
    kbdinp11: TEdit;
    kbdinp3: TEdit;
    kbdinp4: TEdit;
    kbdinp5: TEdit;
    kbdinp6: TEdit;
    kbdinp7: TEdit;
    kbdinp8: TEdit;
    kbdinp9: TEdit;
    keybut0: TCheckBox;
    keybut1: TCheckBox;
    keybut10: TCheckBox;
    keybut11: TCheckBox;
    keybut2: TCheckBox;
    kbdcode10: TEdit;
    kbdcode11: TEdit;
    kbdcode0: TEdit;
    kbdcode1: TEdit;
    kbdcode2: TEdit;
    kbdcode3: TEdit;
    kbdcode4: TEdit;
    kbdcode5: TEdit;
    kbdcode6: TEdit;
    kbdcode7: TEdit;
    kbdcode8: TEdit;
    kbdcode9: TEdit;
    kbdinp0: TEdit;
    kbdinp1: TEdit;
    keybut3: TCheckBox;
    keybut4: TCheckBox;
    keybut5: TCheckBox;
    keybut6: TCheckBox;
    keybut7: TCheckBox;
    keybut8: TCheckBox;
    keybut9: TCheckBox;
    Label10: TLabel;
    Label14: TLabel;
    Label15: TLabel;
    B0: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    Memo2: TMemo;
    Mapfile: TMemo;
    Openmap: TOpenDialog;
    savemap: TSaveDialog;
    tmpnames: TComboBox;
    Label6: TLabel;
    jsdisp: TMemo;
    Label7: TLabel;
    damap: TMemo;
    tmpcombo: TComboBox;
    joysticks: TComboBox;
    kbdinp2: TEdit;
    Label11: TLabel;
    Label12: TLabel;
    Label13: TLabel;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    tmpmemo: TMemo;

    procedure ax_dis0Change(Sender: TObject);
    procedure exitmapClick(Sender: TObject);
    procedure InvertaxClick(Sender: TObject);
    procedure InvertaxMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure loadmapClick(Sender: TObject);
    procedure resetjoymixClick(Sender: TObject);
    procedure rungameDblClick(Sender: TObject);
    procedure runitscriptChange(Sender: TObject);
    procedure savegamelist(Sender: TObject);
    procedure shftynChange(Sender: TObject);
    procedure showlicClick(Sender: TObject);
    procedure translate_btnsClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure getsticks(Sender: TObject);
    procedure kbdinp0Change(Sender: TObject);


    procedure kbdinpXchange(Sender: TObject);
    procedure kbdinp2KeyDown(Sender: TObject; var Key: Word; Shift: TShiftState
      );
    procedure keybutXChange(Sender: TObject);
    procedure loadmapbutClick(Sender: TObject);
    procedure loadstickmap(Sender: TObject);
    procedure savemapbutClick(Sender: TObject);


    procedure damapDblClick(Sender: TObject);
    procedure setdefaultstick(Sender: TObject);
    procedure showhelpscreen(Sender: TObject);


  private

  public

  end;
  procedure runundetached(cmd,parms:string; resultmemo:tmemo); // gather result (script output etc)
  procedure runDetached(cmd,parms:string ); // return immediate, no result in tmemo. IF you quit joymixUI, it keeps running...
  procedure mkhomedir;
var
  jsctl: Tjsctl;
  homedir : string ='';
  execdir : string ='';
  savedir : string ='';
  mapdir  : string ='';

var
  jsarray : tjsArray;
implementation
{$R *.lfm}

{ Tjsctl }
type comboptr = ^tcombobox;
     inpptr   = ^tedit;
     srcptr   = ^tcombobox;
     kbdynptr   = ^tcheckbox;
     kbdcoptr    = ^tedit;
     tresetui = (all,axes,btns,shftstate);
const maxax = 18;
      maxbtn = 18 ;
  var
  axr : array [ 0.. maxax] of comboptr;    // axes, fillaxr ax_dis#
  src : array [ 0 .. maxax ] of srcptr;   // type of axis, fillsrc src#
  dzi : array [ 0 .. maxax ] of inpptr;
  btr : array [ 0 .. maxbtn ] of comboptr; // btns , fillbtx bu##
  kbi : array [ 0 .. maxbtn ] of inpptr;   // kbd input; kbdinp# ; button gives keybd output
  kbyn : array [ 0 .. maxbtn ] of kbdynptr; // kbd y/n, fillkbdYN; keybut#  : is it keybd(y) or stays button (n)
  kbco : array [ 0 .. maxbtn ] of kbdcoptr; // kbdcode#; fillkbdco ; translated kbd input into joymap kbd code.
  resetui : tresetui;

  const norm   = false; // not shifted
        shft  =  true; // shifted
 var  // input array
  kbi_s : array [ norm .. shft ,0 .. maxbtn ] of string;
  // translated array
  kbco_s : array [ norm .. shft,0 .. maxbtn ] of string;
  // btn or kbd array
  kbyn_s : array [ norm .. shft ,0 .. maxbtn ] of boolean;


procedure saveinp(shftyn:boolean); // gets input (visible inputs) and saves them in
                                  // shifted or unshifted buttons storage for input and translated  AND btn=kbd yes or no
var i : integer;
begin
     for i:=0 to maxbtn-1
     do
     begin
       kbi_s[shftyn,i]:=kbi[i]^.Text;
       kbco_s[shftyn,i]:=kbco[i]^.Text;
       kbyn_s[shftyn,i]:=kbyn[i]^.checked;
     end;
end;
procedure putinp(shftyn:boolean); // puts input into visible inputs / translated AND btn=kbd yes or no depending on jsctl.shftyn.checked
var i : integer;
begin
     for i:=0 to maxbtn-1
     do
     begin
       kbi[i]^.text:=kbi_s[shftyn,i];
       kbco[i]^.text:=kbco_s[shftyn,i];
       kbyn[i]^.checked:=kbyn_s[shftyn,i];
     end;
end;

procedure resetjoymixUI(resetact:tresetui);  // run this before loadmap sticks when load stick select (or make reset button ? )
procedure doaxes;
var i: integer;                           // or when reloading axes or button definitions
begin
for i:=0 to maxax-1   // axes / types
do
    begin
        axr[i]^.ItemIndex:=-1;
        src[i]^.ItemIndex:=i;
        jsctl.invertax.Checked[i]:=false;
    end;

end; // doaxes

procedure dobtns;
var i: integer;                           // or when reloading axes or button definitions
begin
for i:=0 to maxbtn-1  // btn inp, btnyn, btn code,
do
    begin
        btr[i]^.ItemIndex:=-1;     //stick
        kbyn[i]^.checked:=false;   // kbd or btn
        kbi[i]^.text:='';          // text for kbd
        kbco[i]^.text:='';         // compiled code
        jsctl.shftbtns.checked[i]:=false;  // shft btns off
    end;
    saveinp(norm); // push empty input to norm and shifted
    saveinp(shft);

end; // dobtns

procedure doshftbtn;
begin
jsctl.shiftbtn.itemindex:=-1; // turn off shift
end; // doshift

procedure doshftynstate;
begin
jsctl.shftyn.checked:=false;
jsctl.shftynchange(jsctl);
end; // shftynstate


//==== procedure begin
begin
with jsctl do
begin
  case resetact of
all:
begin
doaxes; dobtns; doshftbtn; doshftynstate;
end; // all
axes:
begin
doaxes;
end; // axes
btns:
begin
dobtns;       // clear all
doshftynstate; // set to not shifted
doshftbtn;     // set shift button to nothing
 end; // btns

end; // case

end; // with jsctl
end; // procedure

procedure Tjsctl.shftynChange(Sender: TObject);
begin
         if shftyn.Checked
         then
         begin
              normbtns.Hide;
              shftbtns.show;
              shftyn.caption:='Shifted'; shftyn.font.color:=clRed;
              shftbtns.font.Color:=clRed;
              // save unshifted btns => norm !!!!
              saveinp(norm);
              shftbtns.Enabled:=true;
         end
         else
         begin
              normbtns.Show;
              shftbtns.Hide;
              shftyn.caption:='Not shifted'; shftyn.font.color:=cldefault;
              shftbtns.font.Color:=cldefault;
              // save shifted btns => shft !!!!
              saveinp(shft);
              shftbtns.Enabled:=false;


         end;
         // load shifted or unshifted kbd on visual buttons.
         // load shifted or unshifted depends on shftyn.checked
         putinp(jsctl.shftyn.Checked);

end;

procedure Tjsctl.showlicClick(Sender: TObject);
begin
  gplv3.show;
end;

procedure savescript(scriptf:string; scriptsh :tmemo );
begin

   if not fileExists(scriptf)
   then begin
        scriptsh.lines.savetofile(scriptf);
        fpchmod(scriptf,S_IXUSR or S_IRUSR or S_IWUSR);
        end;
end;

procedure fillarx;
begin
        axr[0]:=@jsctl.ax_dis0;
        axr[1]:=@jsctl.ax_dis1;
        axr[2]:=@jsctl.ax_dis2;
        axr[3]:=@jsctl.ax_dis3;
        axr[4]:=@jsctl.ax_dis4;
        axr[5]:=@jsctl.ax_dis5;
        axr[6]:=@jsctl.ax_dis6;
        axr[7]:=@jsctl.ax_dis7;
        axr[8]:=@jsctl.ax_dis8;
        axr[9]:=@jsctl.ax_dis9;
        axr[10]:=@jsctl.ax_dis10;
        axr[11]:=@jsctl.ax_dis11;
        axr[12]:=@jsctl.ax_dis12;
        axr[13]:=@jsctl.ax_dis13;
        axr[14]:=@jsctl.ax_dis14;
        axr[15]:=@jsctl.ax_dis15;
        axr[16]:=@jsctl.ax_dis16;
        axr[17]:=@jsctl.ax_dis17;


end;
procedure fillsrc;
begin
        src[0]:=@jsctl.src0;
        src[1]:=@jsctl.src1;
        src[2]:=@jsctl.src2;
        src[3]:=@jsctl.src3;
        src[4]:=@jsctl.src4;
        src[5]:=@jsctl.src5;
        src[6]:=@jsctl.src6;
        src[7]:=@jsctl.src7;
        src[8]:=@jsctl.src8;
        src[9]:=@jsctl.src9;

        src[10]:=@jsctl.src10;
        src[11]:=@jsctl.src11;
        src[12]:=@jsctl.src12;
        src[13]:=@jsctl.src13;
        src[14]:=@jsctl.src14;
        src[15]:=@jsctl.src15;

        src[16]:=@jsctl.src16;  // dont have these. little bit odd ones out..
        src[17]:=@jsctl.src17;



end;
procedure filldzi;
begin
        dzi[0]:=@jsctl.dz0;
        dzi[1]:=@jsctl.dz1;
        dzi[2]:=@jsctl.dz2;
        dzi[3]:=@jsctl.dz3;
        dzi[4]:=@jsctl.dz4;
        dzi[5]:=@jsctl.dz5;
        dzi[6]:=@jsctl.dz6;
        dzi[7]:=@jsctl.dz7;
        dzi[8]:=@jsctl.dz8;
        dzi[9]:=@jsctl.dz9;
        dzi[10]:=@jsctl.dz10;
        dzi[11]:=@jsctl.dz11;
        dzi[12]:=@jsctl.dz12;
        dzi[13]:=@jsctl.dz13;
        dzi[14]:=@jsctl.dz14;
        dzi[15]:=@jsctl.dz15;
        dzi[16]:=@jsctl.dz16;
        dzi[17]:=@jsctl.dz17;


end;


procedure fillbtx;
begin
        btr[00]:=@jsctl.bu00;
        btr[01]:=@jsctl.bu01;
        btr[02]:=@jsctl.bu02;
        btr[03]:=@jsctl.bu03;
        btr[04]:=@jsctl.bu04;
        btr[05]:=@jsctl.bu05;
        btr[06]:=@jsctl.bu06;
        btr[07]:=@jsctl.bu07;
        btr[08]:=@jsctl.bu08;
        btr[09]:=@jsctl.bu09;
        btr[10]:=@jsctl.bu10;
        btr[11]:=@jsctl.bu11;
        btr[12]:=@jsctl.bu12;
        btr[13]:=@jsctl.bu13;
        btr[14]:=@jsctl.bu14;
        btr[15]:=@jsctl.bu15;
        btr[16]:=@jsctl.bu16;
        btr[17]:=@jsctl.bu17;


end;


procedure fillkbi;
begin
        kbi[0]:=@jsctl.kbdinp0;
        kbi[1]:=@jsctl.kbdinp1;
        kbi[2]:=@jsctl.kbdinp2;
        kbi[3]:=@jsctl.kbdinp3;
        kbi[4]:=@jsctl.kbdinp4;
        kbi[5]:=@jsctl.kbdinp5;
        kbi[6]:=@jsctl.kbdinp6;
        kbi[7]:=@jsctl.kbdinp7;
        kbi[8]:=@jsctl.kbdinp8;
        kbi[9]:=@jsctl.kbdinp9;
        kbi[10]:=@jsctl.kbdinp10;
        kbi[11]:=@jsctl.kbdinp11;
        kbi[12]:=@jsctl.kbdinp12;
        kbi[13]:=@jsctl.kbdinp13;
        kbi[14]:=@jsctl.kbdinp14;
        kbi[15]:=@jsctl.kbdinp15;
        kbi[16]:=@jsctl.kbdinp16;
        kbi[17]:=@jsctl.kbdinp17;


end;
procedure fillkbYN;
begin
        kbyn[0]:=@jsctl.keybut0;
        kbyn[1]:=@jsctl.keybut1;
        kbyn[2]:=@jsctl.keybut2;
        kbyn[3]:=@jsctl.keybut3;
        kbyn[4]:=@jsctl.keybut4;
        kbyn[5]:=@jsctl.keybut5;
        kbyn[6]:=@jsctl.keybut6;
        kbyn[7]:=@jsctl.keybut7;
        kbyn[8]:=@jsctl.keybut8;
        kbyn[9]:=@jsctl.keybut9;
        kbyn[10]:=@jsctl.keybut10;
        kbyn[11]:=@jsctl.keybut11;
        kbyn[12]:=@jsctl.keybut12;
        kbyn[13]:=@jsctl.keybut13;
        kbyn[14]:=@jsctl.keybut14;
        kbyn[15]:=@jsctl.keybut15;
        kbyn[16]:=@jsctl.keybut16;
        kbyn[17]:=@jsctl.keybut17;



end;
procedure fillkbCO;
begin
        kbco[0]:=@jsctl.kbdcode0;
        kbco[1]:=@jsctl.kbdcode1;
        kbco[2]:=@jsctl.kbdcode2;
        kbco[3]:=@jsctl.kbdcode3;
        kbco[4]:=@jsctl.kbdcode4;
        kbco[5]:=@jsctl.kbdcode5;
        kbco[6]:=@jsctl.kbdcode6;
        kbco[7]:=@jsctl.kbdcode7;
        kbco[8]:=@jsctl.kbdcode8;
        kbco[9]:=@jsctl.kbdcode9;
        kbco[10]:=@jsctl.kbdcode10;
        kbco[11]:=@jsctl.kbdcode11;
        kbco[12]:=@jsctl.kbdcode12;
        kbco[13]:=@jsctl.kbdcode13;
        kbco[14]:=@jsctl.kbdcode14;
        kbco[15]:=@jsctl.kbdcode15;
        kbco[16]:=@jsctl.kbdcode16;
        kbco[17]:=@jsctl.kbdcode17;


end;

procedure mkhomedir;
var i : integer; xmapdir,tsrcdoit:string; // tempstr for scripts name to save with savescript proc
begin

// functioning depends on scripts. they get created if they are missing, from the tmemo vars mentioned here.
// in ~/bin ....
//  showmessage('test Fatal: Could not create bin dir in your $HOME: Make sure you can write into it and have it in your $PATH '+homedir);
  homedir:=GetEnvironmentVariable('HOME');
  execdir:=homedir+'/bin/';
  xmapdir:=homedir+'/joymapx';
  if directoryexists(execdir)
  then savedir:=execdir
  else begin mkdir (execdir); if directoryexists(execdir)then savedir:=execdir else
    begin showmessage('Fatal error: Could not create bin dir in your $HOME: Make sure you can write into it and have it in your $PATH '+homedir);
       application.Terminate;
       end; // fatal
       end; // mkdir execdir
  if directoryexists(xmapdir)
  then mapdir:=xmapdir
  else begin mkdir (xmapdir); if directoryexists(xmapdir)then mapdir:=xmapdir else
    begin showmessage('Fatal error: Could not create joymapx  dir in your $HOME: Make sure you can write into it and have it in your $PATH '+homedir);
       application.Terminate;
       end; // fatal
       end; // mkdir execdir


tsrcdoit:=homedir+'/bin/joyls.sh';
savescript(tsrcdoit,jsctl.joylsscript);

tsrcdoit:=homedir+'/bin/joyaxes.sh';
savescript(tsrcdoit,jsctl.getmapscript);

tsrcdoit:=homedir+'/bin/runit.sh';
savescript(tsrcdoit,jsctl.runitscript);
// fill array of combo/edit with pointers to manipulate UI comps: ax_dis#, bu##, kbdinp# easier..
// ugly, but works. dont know how to force IDE into believing
// i have dynamic components...
fillarx;
fillsrc;
fillbtx;
fillkbi;
fillkbCO;
fillkbYN;
filldzi;
// saveinp(norm); see resetjoymixUI
// saveinp(shft);
resetjoymixUI(all);
jsctl.gamelist.lines.LoadFromFile(mapdir+'/gamelist.jmx');
jsctl.rungame.items:=jsctl.gamelist.lines;
end;

procedure fillcombo;
begin
with jsctl do
begin
  tmpcombo.items.add('empty:vendor=0x0000 product=0x000');
tmpnames.items.add( 'Choose stick' );

end


end;

function ExtStr(Search,delim:string; astring :string ):string;
var dbgstr,stmp : string;
begin
     ExtStr:='_notfound';
     dbgstr:=astring;
     if pos(search,dbgstr)>1
        then
        begin
          stmp:=copy(dbgstr,pos(search,dbgstr),255);
          if pos(delim,stmp)>0 then stmp:=copy(stmp,1,pos(delim,stmp)-1);
          // no else. its already done..
          extstr:=stmp;
        end
     else
     extstr:='_not_found';

end;


procedure Tjsctl.getsticks(Sender: TObject);
var tempstr:string; i: longint; // check : longint;

  procedure pushitems( items2push:tstrings; sender:tobject);
  begin
  with sender as tcombobox
  do begin clear; items:=items2push; end;
  end;

begin

     tmpmemo.lines.clear;
  runundetached('joyls.sh','',tmpmemo);
  joysticks.items:=tmpmemo.lines;
     if joysticks.items.Count < 1
        then
        begin
          fillcombo;
          exit;
        end;
     tempstr:=joysticks.items[0];


//  jsctl.debval.caption:='nothing'; // joysticks.items[0];
   if   joysticks.items.Count > 0
   then
   begin
     joysticks.itemindex:=0;
     jsdisp.Lines:=joysticks.Items;  // put them in for display
     // check:=joysticks.items.count;
     tmpcombo.Clear;
     tmpnames.Clear;
     for i:=0 to joysticks.items.count-1
     do begin
       // check:=i;
       tempstr:=extstr('vendor',':',joysticks.Items[i]);
       tmpcombo.items.add(tempstr);
       tmpnames.items.add( copy(joysticks.items[i],1, pos(':',joysticks.items[i]) ) );
       end;
     damap.enabled:=true; // enable damap now.. (?)

     // human palatable display items that control vendor/prod select hex codes..
     for i:=0 to maxax-1 do pushitems(tmpnames.items,axr[i]^);
       // human palatable display items for buttons..
       for i:=0 to maxbtn-1 do pushitems(tmpnames.items,btr[i]^);
   end;




end;

procedure Tjsctl.kbdinp0Change(Sender: TObject);
begin

end;




function getakey:string;

Var  K : TKeyEvent;

begin
//  InitKeyBoard;
//  Writeln('Press keys, press "q" to end.');
//  Repeat
    K:=GetKeyEvent;
    K:=TranslateKeyEvent(K);
{    Write('Got key event with ');
    Case GetKeyEventFlags(K) of
      kbASCII    : Writeln('ASCII key');
      kbUniCode  : Writeln('Unicode key');
      kbFnKey    : Writeln('Function key');
      kbPhys     : Writeln('Physical key');
      kbReleased : Writeln('Released key event');
    end;
    Writeln('Got key : ',KeyEventToString(K));
  Until (GetKeyEventChar(K)='q'); }
  getakey:=KeyEventToString(K);
  DoneKeyBoard;
end;


procedure translateinp(inpstr:string; sender:tobject);
var tempstr :string =''; resltstr:string = ''; i:longint; c:char;
    endstr  :string='';
    lshift : string = ''; relshift : string ='';
    function shiftkey(reslt:string):boolean;     // a shifting (ctrl,alt,meta,shift) key on keyboard (a capital, or so) : NOT the shifted button input.. !!
    begin
    shiftkey:=false;
    shiftkey:=(pos('shift',reslt)>0) or (pos('alt',reslt)>0) or (pos('meta',reslt)>0) or (pos('ctrl',reslt)>0);
    end;

begin

i:=1;
if pos('#',inpstr)>0
then inpstr:=copy(inpstr,1,pos('#',inpstr)-1);
while i <= length(inpstr)
do
  begin
    c:=inpstr[i];
    lshift:=''; relshift:='';
    if c in ['A'..'Z']  // c=upcase(c)
    then begin lshift:=' leftshift '; relshift:=' REL leftshift ';    end; // common upcase
    c:=lowercase(c);
    if (c <> ' ')
    then
    begin
    case c of
    '[':         // a special key, non printing: function keys, keypad, etc.
      begin
        resltstr:=copy( inpstr,i+1,255);
        inc(i,pos(']',resltstr));         // look for end of special key = ']' otherwise f1 is going to be translated
        resltstr:=copy( resltstr,1,pos(']',resltstr)-1);
        if shiftkey(resltstr)
        then begin
             endstr:=endstr+ ' REL '+resltstr; // release should go to end in same order as pressed
             tempstr:=tempstr+' '+resltstr;  // shift key should not release now, but after the next non-deadkey ..
        end
        else
        begin
        tempstr:=tempstr+' '+resltstr+' REL '+resltstr+' '+endstr;  // normal keypress + release last deadkey
        endstr:='';
        end;
      end
     else
      begin
       tempstr:=tempstr+' '+lshift+c+' REL '+c+relshift+' '+endstr;
       endstr:='';
      end;  // else
    end; // case

    end; // c not a space
    inc(i);
    end; // while
  tempstr:=trim(tempstr);     // remove leading + trailing spaces. loadmap will not accept more than one...
with sender as tedit
  do text:=tempstr;

end;





procedure Tjsctl.kbdinpXchange(Sender: TObject);
var i: integer;
begin

for i:=0 to maxbtn-1 do if sender=kbi[i]^ then translateinp(kbi[i]^.text,kbco[i]^);

{   if sender = kbdinp0 then translateinp(kbdinp0.Text,kbdcode0); // old code
 }
end;


procedure Tjsctl.kbdinp2KeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
var checkstr:string;
begin
key:=TranslateKeyEvent(key);

checkstr:=KeyEventToString(key);

text:=text+' '+KeyEventToString(key);

end;


procedure Tjsctl.keybutXChange(Sender: TObject);
var ischecked : boolean = false; i : integer;
begin
//        setkbdonoff(sender);
        with sender as tcheckbox
          do ischecked:=checked; // check if kbd function or just button
for i:=0 to maxbtn - 1 do if sender=kbyn[i]^ then kbi[i]^.Enabled:=ischecked;
{
if sender = keybut0 then kbdinp0.enabled:=ischecked; // old code
}
end;

function mapxmatch(srch:string):longint;  // gets the vendor/product ID
  var y,i:longint;    // srch = 'vendor=0x#### product=0x####' e.g. :  vendor=0x04d8 product=0x0100 of line X
  begin               // mapxmatch sees if it can find the stick. otherwise itemindex of that axis is set to none, -1
  y:=-1;
with jsctl do for i:=0 to tmpcombo.items.Count-1  // tmcombo contains the vendor= product= entries as now found in system. it wont remember history of sticks plugged in.
      do if (pos(srch,tmpcombo.items[i]) > 0)
      then begin y:=i; break; end;
  mapxmatch:=y;
  end; // function

procedure Tjsctl.loadmapbutClick(Sender: TObject);
var i,x,ndx :longint;  kbdinp : string ='';



begin
// first normal buttons, btnsnorm
openmap.InitialDir:=mapdir;
mapfile.clear;
if openMap.execute
  then   if fileExists(openmap.filename) then runundetached('joyaxes.sh ',openmap.Filename+' btnsnorm',mapfile); // mapfile.Lines.LoadFromFile(openmap.FileName);
//  then   runundetached('joygetmap.sh ',openmap.Filename+' btns',mapfile); // mapfile.Lines.LoadFromFile(openmap.FileName);
if mapfile.lines.count < 0 then exit;

resetjoymixUI(btns);
{  for i := mapfile.lines.Count to maxbtn-1
    do begin
            // mapfile.lines.add('');
            kbyn[i]^.Checked:=false;
            kbi[i]^.text:='';
            shftbtns.Checked[i]:=false;
        end;// create up to maxbtn entries... }

   with mapfile do
     begin
       for i:=0 to min(lines.count-1,maxbtn-1) do
         begin   // format :   #btn|the string
          x:=strtoint(copy(lines[i],1,pos('|',lines[i])-1)); // src=X  button number
          kbdinp:=copy(lines[i],pos('|',lines[i])+1,255);    // extract kbdinp
          kbyn[x]^.checked:=true;
          kbi[x]^.text:=kbdinp;
          kbi_s[norm,x]:=kbdinp;
          normbtns.Checked[x]:=true;
         end;
     end;
saveinp(norm); // save it !!
//if shiftbtn.itemindex > -1
// then
// get shift button
runundetached('joyaxes.sh',openmap.Filename+' shiftbtn ',mapfile); // cmd: joygetmap.sh some.map axes ## mapfile.Lines.LoadFromFile(openmap.FileName);
     if mapfile.lines.count >0
     then begin    // format: <a single number on a single line, line index 0 >
     ndx:=strtoint(mapfile.lines[0]);
     jsctl.shiftbtn.itemindex:=ndx;
     end;

begin
   // now shifted buttons, btnshifted
      runundetached('joyaxes.sh ',openmap.Filename+' btnshifted',mapfile); // mapfile.Lines.LoadFromFile(openmap.FileName);
   //  then   runundetached('joygetmap.sh ',openmap.Filename+' btns',mapfile); // mapfile.Lines.LoadFromFile(openmap.FileName);

     for i := mapfile.lines.Count to maxbtn-1
       do begin  // format :   #btn|the string
               // mapfile.lines.add('');
               kbyn[i]^.Checked:=false;
               kbi[i]^.text:='';
           end;// create up to maxbtn entries...
      with mapfile do
        begin
          for i:=0 to min(lines.count-1,maxbtn-1) do
          // if kbYN[i]^.checked then kbi[i]^.text:=lines[i];    // wrong. should check for
          begin
             x:=strtoint(copy(lines[i],1,pos('|',lines[i])-1)); // src=X
             kbdinp:=copy(lines[i],pos('|',lines[i])+1,255);
             kbyn[x]^.checked:=true;
             kbi[x]^.text:=kbdinp;
             kbi_s[shft,x]:=kbdinp; // shifted !!!!
             shftbtns.Checked[x]:=true;
            end;
        end;
saveinp(shft);
 end;  // if there is a shiftbtn ...


begin     // now not shifted joybuttons, joybtnsnorm

      runundetached('joyaxes.sh ',openmap.Filename+' joybtnsnorm',mapfile); // mapfile.Lines.LoadFromFile(openmap.FileName);
   //  then   runundetached('joygetmap.sh ',openmap.Filename+' btns',mapfile); // mapfile.Lines.LoadFromFile(openmap.FileName);

      with mapfile do
        begin
          for i:=0 to min(lines.count-1,maxbtn-1) do

          begin    // format :   #btn|<empty>
             x:=strtoint(copy(lines[i],1,pos('|',lines[i])-1)); // src=X
             kbdinp:=''; // no kbd
             kbyn[x]^.checked:=false;
             kbi[x]^.text:=kbdinp;
             kbi_s[norm,x]:=kbdinp; // shifted !!!!
             normbtns.Checked[x]:=true;
             // shftbtns.Checked[x]:=false;
            end;
        end;
end;

begin     // now shifted joybuttons, joybtnshifted

      runundetached('joyaxes.sh ',openmap.Filename+' joybtnshifted',mapfile); // mapfile.Lines.LoadFromFile(openmap.FileName);
   //  then   runundetached('joygetmap.sh ',openmap.Filename+' btns',mapfile); // mapfile.Lines.LoadFromFile(openmap.FileName);

      with mapfile do
        begin
          for i:=0 to min(lines.count-1,maxbtn-1) do
          // if kbYN[i]^.checked then kbi[i]^.text:=lines[i];    // wrong. should check for
          begin   // format :   #btn|<empty>
             x:=strtoint(copy(lines[i],1,pos('|',lines[i])-1)); // src=X
             kbdinp:=''; // no kbd
             kbyn[x]^.checked:=false;
             kbi[x]^.text:=kbdinp;
             kbi_s[shft,x]:=kbdinp; // shifted !!!!
             shftbtns.Checked[x]:=true;
            end;
        end;

 end;  // if there is a shiftbtn ...


// get the button map vendor/prod "butes"
runundetached('joyaxes.sh',openmap.Filename+' butes',mapfile); // cmd: joygetmap.sh some.map axes ## mapfile.Lines.LoadFromFile(openmap.FileName);
{  simple straight forward. linenr = button nr. joyaxes SORTS the output to correct order ;-)
vendor=0x044f product=0xb68d
..
vendor=0x0ABC product=0xbDEF

}
     if (mapfile.lines.count < 1 ) then exit;

for i:=0 to min(maxbtn-1,mapfile.lines.count-1)                // either maxbtn or lines count. buttons are always sorted. manual change is disastrous .. cannot do more than array is large.
    do
    begin
       x:=strtoint(copy(mapfile.lines[i],1,pos('|',mapfile.lines[i])-1)); // src=X
       kbdinp:=copy(mapfile.lines[i],pos('|',mapfile.lines[i])+1,255);
       btr[x]^.itemindex:=mapxmatch(kbdinp);         // mapping of button #x to button #y is not supported by joymixUI (its also quite useless.. put string on button you want...
    end;

shftYN.checked:=false; // set to "Not shifted"
shftyn.caption:='Not shifted';
shftyn.font.color:=clBlue;
shftbtns.font.Color:=clBlue;
putinp(norm);          // put normal button values into visual

   jsctl.Caption:='Joystick mixer control: '+openmap.Filename;
end;

procedure Tjsctl.loadstickmap(Sender: TObject);
var tmps:string;    dzval,srcnr,ndx,i : integer;

  begin
    openMap.InitialDir:=mapdir;
   if openMap.execute
  then  begin
  mapfile.clear; // empty the mapfile
  // old code runundetached('joygetmap.sh',openmap.Filename+' axes',mapfile); // cmd: joygetmap.sh some.map axes ## mapfile.Lines.LoadFromFile(openmap.FileName);
  // get the axes vend/prod mapping "axes" (not axIs! )
  runundetached('joyaxes.sh',openmap.Filename+' axes',mapfile); // cmd: joygetmap.sh some.map axes ## mapfile.Lines.LoadFromFile(openmap.FileName);
{  output from joyaxes.sh axEs : get vendor / product per axis.
vendor=0x044f product=0xb68d|0
vendor=0x044f product=0xb68d|1
vendor=0x044f product=0xb68d|2
vendor=0x044f product=0xb68d|3
vendor=0x044f product=0xb68d|4
vendor=0x04d8 product=0x0100|5
vendor=0x044f product=0xb68d|6
vendor=0x044f product=0xb68d|7
vendor=0x044f product=0xb68d|8
vendor=0x044f product=0xb68d|9
vendor=0x044f product=0xb68d|16
vendor=0x044f product=0xb68d|17
dep
}
     if (mapfile.lines.count < 1 ) then exit;
resetjoymixUI(axes);
for i:=0 to maxax-1 do axr[i]^.itemindex:=-1;  // set to null, no value..
for i:=0 to min(maxax-1,mapfile.lines.count-1) // either maxax or lines count. cannot do more than array is large.
    do
      begin
        tmps:=copy(mapfile.lines[i],pos('|',mapfile.lines[i])+1,255); // find axis number in this line
        ndx:=strtoint(tmps);                           // index of axis

        axr[ndx]^.itemindex:=mapxmatch(copy(mapfile.lines[i],1,pos('|',mapfile.lines[i])-1));

    // do axr[i]^.itemindex:=mapxmatch(mapfile.lines[i]);
      end;

// get deadzones
runundetached('joyaxes.sh',openmap.Filename+' deadzones ',mapfile); // cmd: joyaxes.sh some.map axes ## mapfile.Lines.LoadFromFile(openmap.FileName);
{ output example :
cmd: joyaxes.sh rb3dv4force.map  deadzones
0|10000
1|10000
5|0
6|0
 }
for i:=0 to maxax-1 do dzi[i]^.text:='0'; // reset to deadzone = 0
if (mapfile.lines.count > 0 )
     then begin
for i:=0 to min(maxax-1,mapfile.lines.count-1) // lines count. cannot do more than array is large.
  do
    begin
 // find axis number in this line
      tmps:=copy(mapfile.lines[i],1,pos('|',mapfile.lines[i])-1);
      ndx:=strtoint(tmps);                           // index of axis
      tmps:=copy(mapfile.lines[i],pos('|',mapfile.lines[i])+1,255);      // find type number in this line
      dzval:=strtoint(tmps);                        // deadzone val
      dzi[ndx]^.text:=inttostr(dzval);              // make sure its a number..
     end;
     end;
// get inverted axes...
runundetached('joyaxes.sh',openmap.Filename+' invert ',mapfile); // cmd: joyaxes.sh some.map axes ## mapfile.Lines.LoadFromFile(openmap.FileName);
{   output is axis numbers.
2
}
{ debugmemo.lines.Clear;

     for i:=0 to invertax.items.count-1
         do if invertax.checked[i]
         then
         debugmemo.lines.add(invertax.items[i]+' checked');
}
for i:=0 to maxax-1 do invertax.checked[i]:=false;  // set to null, no value..
for i:=0 to min(maxax-1,mapfile.lines.count-1) // either maxax or lines count. cannot do more than array is large.
    do
      begin
        tmps:=mapfile.lines[i]; // axis number in this line
        ndx:=strtoint(tmps);    // index of axis
        invertax.checked[ndx]:=true;
      end;

// get the axes src ( the type of the axis) in proper order  "axis" (not axEs! )
runundetached('joyaxes.sh',openmap.Filename+' axis',mapfile); // cmd: joyaxes.sh some.map axes ## mapfile.Lines.LoadFromFile(openmap.FileName);
{ output from joyaxes.sh axIs : sometimes, a different type is on axis X. e.g, a type 6 (rZ) on axis 2 (Z) : 2|6 ( typical for some logitech... )
0|0
1|1
2|2
3|3
4|4
5|5
6|6
7|7
8|8
9|9
16|16
17|17


// outputs typenr|axisnr : example : 6|2 => throttle , nr 6, gets mapped on axis nr 2 (= Z ). all logisticks extreme / pro / force do this..
}
if (mapfile.lines.count < 1 ) then exit;
for i:=0 to maxax-1 do src[i]^.itemindex:=i; // reset to axis = type nr, "normal" situation.
for i:=0 to min(maxax-1,mapfile.lines.count-1) // lines count. cannot do more than array is large.
  do
    begin
      tmps:=copy(mapfile.lines[i],pos('|',mapfile.lines[i])+1,255); // find axis number in this line
      ndx:=strtoint(tmps);                           // index of axis
      tmps:=copy(mapfile.lines[i],1,pos('|',mapfile.lines[i])-1); // find type number in this line
      srcnr:=strtoint(tmps);                        // typenr
      src[ndx]^.itemindex:=srcnr;
     end;



 jsctl.Caption:='Joystick mixer control: '+openmap.Filename+' (sticks)';
  end; // if filemap was loaded..

  end;





procedure Tjsctl.ax_dis0Change(Sender: TObject);
begin

end;


procedure Tjsctl.InvertaxClick(Sender: TObject);
var i : integer;
begin
  {   debugmemo.lines.Clear;
     for i:=0 to invertax.items.count-1
         do if invertax.checked[i]
         then
         debugmemo.lines.add(invertax.items[i]+' checked');
  }
end;

procedure Tjsctl.InvertaxMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  invertaxclick(sender);
end;

procedure Tjsctl.loadmapClick(Sender: TObject);
begin
  openmap.InitialDir:=mapdir;
  if openmap.execute
  then runDetached('runit.sh ',' xterm '+'-T "loadmap '+ExtractFileName(openmap.filename)+' ('+extractfilepath(openmap.filename)+') " -e loadmap -c '+openmap.filename+' & ');

end;

procedure Tjsctl.resetjoymixClick(Sender: TObject);
begin
  resetjoymixUI(all);
end;

procedure Tjsctl.rungameDblClick(Sender: TObject);
var gamex, mapfilex : string;
begin
//   rundetached('runit.sh ',' xterm -T -e '+rungame.items[rungame.itemindex]);
gamex:=''; mapfilex:='';
if rungame.itemindex < 0 then exit;
gamex:=rungame.items[rungame.itemindex];
if pos('|',gamex)>0 // if | then trailing = mapfile
then begin
          mapfilex:=copy(gamex,pos('|',gamex)+1,255);  // get mapfile spec
          runDetached('runit.sh ',' xterm  -T "'+mapfilex+'" -e loadmap -c '+mapfilex);
          gamex:=copy(gamex,1,pos('|',gamex)-1);  // get game + params
     end;

rundetached('runit.sh ',' xterm -T "'+gamex+ '" -e '+gamex);
end;

procedure Tjsctl.runitscriptChange(Sender: TObject);
begin

end;

procedure Tjsctl.savegamelist(Sender: TObject);
begin
  gamelist.lines.SaveToFile(mapdir+'/gamelist.jmx');
  rungame.items:=gamelist.lines;
end;


procedure Tjsctl.exitmapClick(Sender: TObject);
begin
//        runDetached('runit.sh ',' psg -nr loadmap & ');
       runDetached('runit.sh ',' ps -ef|grep -w loadmap|awk ''{print $2}'' |while read x; do kill -1 $x; done');
end;


procedure Tjsctl.translate_btnsClick(Sender: TObject);
var i : integer;
begin
for i:=0 to maxbtn-1
    do
      begin
        kbco[i]^.Text:='';
        if kbyn[i]^.Checked then translateinp(kbi[i]^.text,kbco[i]^);
      end;
{ old code,,....
if keybut0.Checked then translateinp(kbdinp0.Text,kbdcode0);
..
..
if keybut17.Checked then translateinp(kbdinp17.Text,kbdcode17);
}
end;

procedure Tjsctl.FormActivate(Sender: TObject);
begin

end;

procedure Tjsctl.savemapbutClick(Sender: TObject);
begin
  savemap.InitialDir:=mapdir;
  if savemap.execute
  then  begin
        damapdblClick(sender);
        damap.Lines.SaveToFile(savemap.filename);
  end;
    jsctl.Caption:='Joystick mixer control: '+savemap.Filename+' (map)';
end;


procedure Tjsctl.damapDblClick(Sender: TObject);
var i: integer; kbdorbut : array of string = (' target=joybtn button=',' target=kbd button="');

    function shftbtn(yep:boolean): string; // the button that enables the shifted buttons..
    begin
             if yep then
             shftbtn:='shift ' // first word on the assignment line. button gets omitted ( could be axis to, apparently (??)
             else shftbtn:='button '; // ordinary button.
    end; // shftbtn yep or nope

    function btn_shfted(yep:boolean): string; // a button has a shifted value
    begin
             if yep then btn_shfted:='flags=shift '
             else btn_shfted:=''; // invert lonely does not work. bug in joymap ?? fixed. was a bug
    end; // btn_shfted yep or nope

    function kbdseq(id:string; iskbd:boolean; sender:tobject):string;  // is a kbd if true otherwise, a joybtn
    begin
        with sender as tedit do if iskbd then kbdseq:=text+'" #' else kbdseq:=id+' # ""'; // double quotes to make sure there s no text imported when loading map file
    end;  // kbdseq

    function axinverted(itemnr:integer):string;
    begin
                if invertax.Checked[itemnr]
                then axinverted:=' flags=invert'
                else axinverted:='';
    end;  // axinverted

    procedure savebtns;
    begin
     if shftyn.Checked  // save shifted btns if thats last work done: it has not been saved yet.
         then
         begin
              saveinp(shft); // push visual work to shft array
         end
         else
         begin          // save unshifted btns if thats last work done: it has not been saved yet.
              saveinp(norm);   // push visual work to unshift array
         end;

    end;     // savebtns

    function axdeadzone(dzitem:string):string;
    var dznum:integer; dzresult:string = '';
    begin
    dznum:=strtoint(dzitem);
    if dznum > 0
    then result:='deadzone='+dzitem
    else result:='';
    end;

var shiftstate:boolean = false;
begin
  with damap.lines
  do begin
     clear;
// axis vendor=0x046d product=0xc215 src=0 target=joyaxis axis=0 min=0 max=1023
    if tmpcombo.Items.count <0
    then begin add('# NOTE: NO devices found... '); exit; end;
    // axes ...        plz note: only Xhat0 en Yhat0. extend code for more... 18 upto 23 if u need that (4 hats ). (gamepad ppl.. )
    // axes ...        plz note: joymap code based on analogue CH stick, which does not do +/- 32676 as req'd by linux. joymap mangles good values
    add('# NOTE: if axes/buttons are undefined, first device is used .. '+tmpnames.Items[0]);
    add('# NOTE: Do NOT REMOVE the "|" characters in this file.');
    add('# NOTE: the original keyboard sequences are saved behind the "|" character so you can reload them.... and edit... do not change, unless you know what you are doing' );
    add('# NOTE:  ORDER of the lines for buttons in this file is important. do not change it. save a blank map to find out what the order is..      ');
    add('# the min and max values are no longer necessary IF your joymap / loadmap version is 5.x or higher. upgrade joymap ');
    add ('# you MUST start loadmap with -c option: loadmap -c my.map ');

// write the axis entries...
for i:=0 to maxax-1
    do
      begin
//        add('axis '+tmpcombo.Items[max(ax_dis0.itemindex,0)]+' src='+ src0.Items[src0.itemindex]+' target=joyaxis axis=0 # min=0 max='+factor0.items[factor0.itemindex] +' # 1023 X axis '+tmpnames.Items[max(ax_dis0.itemindex,0)]+'|'+tmpcombo.Items[max(ax_dis0.itemindex,0)]);
        if axr[i]^.itemindex >-1
        then
            begin
            add('axis '+tmpcombo.Items[max(axr[i]^.itemindex,0)]+' src='+ src[i]^.Items[src[i]^.itemindex]+' target=joyaxis axis='+intToStr(i)+' '+axinverted(i)+axdeadzone(dzi[i]^.text)+' #   X axis '+tmpnames.Items[max(axr[i]^.itemindex,0)]+'|'+tmpcombo.Items[max(axr[i]^.itemindex,0)]);
            end;
      end;
// old code ...
{    add('axis '+tmpcombo.Items[max(ax_dis0.itemindex,0)]+' src='+ src0.Items[src0.itemindex]+' target=joyaxis axis=0 # min=0 max='+factor0.items[factor0.itemindex] +' # 1023 X axis '+tmpnames.Items[max(ax_dis0.itemindex,0)]+'|'+tmpcombo.Items[max(ax_dis0.itemindex,0)]);
}

// buttons .....
// save btns not yet saved: if in shifted state (jsctl.shftyn.checked=true), safe shifted, else save unshifted.
   savebtns;
   shiftstate:=jsctl.shftyn.Checked;  // remember state of UI inputs
   putinp(norm); // copy saved not shifted "normal" buttons into visual
    for i:=0 to maxbtn-1  // unshifted first
    do
    begin     // use *_s arrays here..
      if  normbtns.Checked[i] // cycle through, if applicable, otherwise skip (=disable button unshifted)'
      then
      if btr[i]^.itemindex >-1  // cycle through and add 'shift ' if applicable.(shiftbtn.itemindex > -1
      then
      // sample lines :
      // keep button :  button vendor=0x044f product=0xb68d src=1  target=joybtn button=1 # """Thrustmaster T.Flight Hotas One":|#
      // make kbd    :  button vendor=0x044f product=0xb68d src=2  target=kbd button="n REL n" #"Thrustmaster T.Flight Hotas One":|n # radar
          // shftbtn = 'shift ' only if defined...      //   vendor=0x####  product=0x####     // src=#type          //target=[kbd|btn]                    // joymap key codes ...           // joystick name for convenience             // | input code human readable
      add(shftbtn(jsctl.shiftbtn.itemindex = i)+tmpcombo.items[btr[i]^.itemindex]+' src='+intToStr(i)+' '+kbdorbut[shortint(kbYN[i]^.checked)]+kbdseq(intToStr(i),kbYN[i]^.checked,kbco[i]^)+tmpnames.Items[btr[i]^.itemindex]  +'|'+kbi[i]^.text);
    end;

    // one more time IF jsctl.shiftbtn.itemindex > -1 => meaning there are shifted buttons...

if (jsctl.shiftbtn.itemindex > -1)  // is there a shift button assigned. if not, do not write anything (?)
then
begin
  putinp(shft); // copy saved shifted buttons into visual
  for i:=0 to maxbtn-1  // now the shifted
    do
    begin     // use *_s arrays here..
      if  shftbtns.Checked[i] // cycle through, if applicable : add 'flags=shift ' otherwise disable shifted button
      then
      // keep button :  button vendor=0x044f product=0xb68d src=1  target=joybtn button=1 # """Thrustmaster T.Flight Hotas One":|#
      // make kbd    :  button vendor=0x044f product=0xb68d src=2  target=kbd button="n REL n" #"Thrustmaster T.Flight Hotas One":|n # radar
          // shftbtn = 'shift '                         //   vendor=0x####  product=0x####     // src=#type          //target=[kbd|btn]              // is a shift btn       // joymap key codes ...           // joystick name for convenience             // | input code human readable
      if btr[i]^.itemindex >-1
      then
      add('button '+ { vendor / product :} tmpcombo.items[btr[i]^.itemindex]+' src='+intToStr(i)
      +' flags=shift '+
      {kbd|btn :} kbdorbut[shortint(kbYN[i]^.checked)]+
      {code :} kbdseq(intToStr(i),kbYN[i]^.checked,kbco[i]^)+tmpnames.Items[btr[i]^.itemindex]  +'|'+kbi[i]^.text);
    end;
end;
// restore UI to unshifted state
if shiftstate then putinp(shft) else putinp(norm);

// shftyn.checked:=norm; // shifted values are now in visual so need to simulate going back to unshifted
// shftynChange(shftyn); // and call same code that does that properly.


 end;   // with damap.lines do
end; // procedure

procedure Tjsctl.setdefaultstick(Sender: TObject);
var i: longint;
begin
    if tmpcombo.itemindex >-1
    then
    begin
      with tmpcombo do
        begin

          for i:=0 to maxax-1 do axr[i]^.itemindex:=itemindex;
          for i:=0 to maxbtn-1 do btr[i]^.itemindex:=itemindex;
         end;
       end;



end;

procedure Tjsctl.showhelpscreen(Sender: TObject);
begin
  stickpic.show;
end;

procedure runundetached(cmd,parms:string; resultmemo : Tmemo);
var
  Process: TProcess; cmdfull:string;
  I: Integer;  tempstr : string;
begin
  Process := TProcess.Create(nil);
  try

    Process.InheritHandles := False;
    Process.Options := [];
    Process.Options := Process.Options + [poWaitOnExit, poUsePipes];
    Process.ShowWindow := swoShow;

    // Copy default environment variables including DISPLAY variable for GUI application to work
    for I := 1 to GetEnvironmentVariableCount do
      Process.Environment.Add(GetEnvironmentString(I));


     cmdfull:=FindDefaultExecutablePath(cmd);
     Process.Executable :=cmdfull;

     Process.Parameters.add(parms);
    Process.Execute;
    resultmemo.Lines.LoadFromStream(Process.Output);

{    tempstr:=resultmemo.lines;
    gamecontrolform.cmdout.lines.add(Process.Executable+' '+cmdfull+' '+parms);
 }
  finally

    Process.Free;
    // sleep(400);

  end;
end;
procedure runDetached(cmd,parms:string );
var
  Process: TProcess; cmdfull:string;
  I: Integer;  tempstr : string;
begin
  Process := TProcess.Create(nil);
  try

    Process.InheritHandles := False;
    Process.Options := [];
    Process.Options := Process.Options + [poWaitOnExit, poUsePipes];
    Process.ShowWindow := swoShow;

    // Copy default environment variables including DISPLAY variable for GUI application to work
    for I := 1 to GetEnvironmentVariableCount do
      Process.Environment.Add(GetEnvironmentString(I));


     cmdfull:=FindDefaultExecutablePath(cmd);
     Process.Executable :=cmdfull;

     Process.Parameters.add(parms);
    Process.Execute;
    // resultmemo.Lines.LoadFromStream(Process.Output);

{    tempstr:=resultmemo.lines;
    gamecontrolform.cmdout.lines.add(Process.Executable+' '+cmdfull+' '+parms);
 }
  finally

    Process.Free;
    // sleep(400);

  end;
end;

begin
// fillcombo;
jsarray[ax]:=tcombobox.create(nil);
jsarray[ax].Parent:=jsctl;
jsarray[ax].top:=10;
jsarray[ax].Left:=10;
jsarray[ax].show;

end.

